function varargout = GUI_start(varargin)
% GUI_START M-file for GUI_start.fig
%      
% Copyright 2008 Nick Van Damme

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @GUI_start_OpeningFcn, ...
    'gui_OutputFcn',  @GUI_start_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before GUI_start is made visible.
function GUI_start_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to GUI_start (see VARARGIN)

% Choose default command line output for GUI_start
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

initialize_gui(hObject, handles, false);

% UIWAIT makes GUI_start wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = GUI_start_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;




% --------------------------------------------------------------------
function initialize_gui(fig_handle, handles, isreset)
% If the metricdata field is present and the reset flag is false, it means
% we are we are just re-initializing a GUI by calling it from the cmd line
% while it is up. So, bail out as we dont want to reset the data.
% if isfield(handles, 'metricdata') && ~isreset
%     return;
% end

sbioreset;
handles.toolboxpath = pwd;

handles.projectdata.nbComp = 0;
handles.projectdata.nbSpecies = 0;
handles.projectdata.nbReactions = 0;
handles.modelOK = 0;

handles.simulationdata.sim_time = 0;
handles.simulationdata.eq_time = 0;
handles.simulationdata.nbCells = 1;
handles.simulationdata.div_mean = 2400;
handles.simulationdata.div_spread = 400;

handles.events = {};
handles.eventdata.event_time = [];
handles.eventdata.event_species = [];
handles.eventdata.event_amount = [];

% Update handles structure
guidata(handles.figure1, handles);



%--------------------------------------------------------------------------
% MENUBAR
%--------------------------------------------------------------------------

% Menubar
function File_Callback(hObject, eventdata, handles)
% hObject    handle to File (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

function Load_Callback(hObject, eventdata, handles)
% hObject    handle to Load (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

load_button_Callback(hObject, eventdata, handles)

function Close_Callback(hObject, eventdata, handles)
% hObject    handle to Close (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

user_response = modaldlg('Title','Confirm Close');
switch lower(user_response)
    case 'no'
        % take no action
    case 'yes'
        % Prepare to close GUI application window
        delete(handles.figure1)
end

% --------------------------------------------------------------------
function Help_Callback(hObject, eventdata, handles)
% hObject    handle to Help (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
Help('Title','Help');



%--------------------------------------------------------------------------
% PROJECT
%--------------------------------------------------------------------------

% --- Executes on button press in load_button.
function load_button_Callback(hObject, eventdata, handles)
% hObject    handle to load_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[FileName,PathName] = uigetfile('*.sbproj');
if ischar(FileName) && ischar(PathName)
    cd(PathName)
    sbioreset
    sbioloadproject(FileName)
    handles.main.filename = FileName;
    set(handles.name, 'String', handles.main.filename );
    handles.main.pathname = PathName;
    m = sbioselect('Type', 'sbiomodel');
    model = m(1);
    handles.main.model = model;
    
    set(handles.nbCompartments, 'String', length(model.compartments));
    set(handles.nbSpecies, 'String', length(model.species));
    set(handles.nbReactions, 'String', length(model.reactions));

    cd(handles.toolboxpath)
    handles.modelOK = control;
    if (handles.modelOK)
        set(handles.control,'BackgroundColor', 'g');
        set(handles.control,'String', 'Model OK');
    else
        set(handles.control,'BackgroundColor', 'r');
        set(handles.control,'String', strvcat('Model does not conform to requested standards','Click Help for information') );
    end

    %desactivate all events
    for i=1:length(model.events)
        model.events(i).Active = 0;
    end

    list = cell(length(model.species),1);
    for i=1:length(model.species)
        list{i} = model.species(i).Name;
    end
    set(handles.popupmenu2, 'String', list);
    
    reactions = cell(length(model.reactions),2);
    for i=1:length(model.reactions)
        reactions{i,1} = i;
        reactions{i,2} = model.reactions(i).reaction;
    end
    handles.reactionlist = reactions;
    handles.reactionchecks = zeros(length(model.reactions),1);
else

end
guidata(hObject,handles)



% --- Executes during object creation, after setting all properties.
function control_CreateFcn(hObject, eventdata, handles)
% hObject    handle to control (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% --- Executes during object deletion, before destroying properties.
function uipanel13_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to uipanel13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --- Executes during object creation, after setting all properties.
function uipanel13_CreateFcn(hObject, eventdata, handles)
% hObject    handle to uipanel13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called





%--------------------------------------------------------------------------
% SIMULATION
%--------------------------------------------------------------------------

% --- Executes during object creation, after setting all properties.
function sim_time_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sim_time (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function sim_time_Callback(hObject, eventdata, handles)
% hObject    handle to sim_time (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of sim_time as text
%        str2double(get(hObject,'String')) returns contents of sim_time as a double
sim_time = str2double(get(hObject, 'String'));
if isnan(sim_time)
    set(hObject, 'String', 400);
    errordlg('Input must be a number','Error');
end

% Save the new nbCells value
handles.simulationdata.sim_time = sim_time;
guidata(hObject,handles)

% --- Executes during object creation, after setting all properties.
function eq_time_in_CreateFcn(hObject, eventdata, handles)
% hObject    handle to eq_time_in (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function eq_time_in_Callback(hObject, eventdata, handles)
% hObject    handle to eq_time_in (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of eq_time_in as text
%        str2double(get(hObject,'String')) returns contents of eq_time_in as a double
eq_time = str2double(get(hObject, 'String'));
if isnan(eq_time)
    set(hObject, 'String', 0);
    errordlg('Input must be a number','Error');
end

% Save the new nbCells value
handles.simulationdata.eq_time = eq_time;
guidata(hObject,handles)

% --- Executes during object creation, after setting all properties.
function nbCells_CreateFcn(hObject, eventdata, handles)
% hObject    handle to nbCells (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function nbCells_Callback(hObject, eventdata, handles)
% hObject    handle to nbCells (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of nbCells as text
%        str2double(get(hObject,'String')) returns contents of nbCells as a double
nbCells = str2double(get(hObject, 'String'));
if isnan(nbCells)
    set(hObject, 'String', 1);
    errordlg('Input must be a number','Error');
end

% Save the new nbCells value
handles.simulationdata.nbCells = nbCells;
guidata(hObject,handles)

% --- Executes during object creation, after setting all properties.
function div_mean_in_CreateFcn(hObject, eventdata, handles)
% hObject    handle to div_mean_in (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function div_mean_in_Callback(hObject, eventdata, handles)
% hObject    handle to div_mean_in (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of div_mean_in as text
%        str2double(get(hObject,'String')) returns contents of div_mean_in as a double
div_mean = str2double(get(hObject, 'String'));
if isnan(div_mean)
    set(hObject, 'String', 2400);
    errordlg('Input must be a number','Error');
end

% Save the new nbCells value
handles.simulationdata.div_mean = div_mean;
guidata(hObject,handles)


% --- Executes during object creation, after setting all properties.
function div_spread_in_CreateFcn(hObject, eventdata, handles)
% hObject    handle to div_spread_in (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function div_spread_in_Callback(hObject, eventdata, handles)
% hObject    handle to div_spread_in (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of div_spread_in as text
%        str2double(get(hObject,'String')) returns contents of div_spread_in as a double
div_spread = str2double(get(hObject, 'String'));
if isnan(div_spread)
    set(hObject, 'String', 400);
    errordlg('Input must be a number','Error');
end

% Save the new nbCells value
handles.simulationdata.div_spread = div_spread;
guidata(hObject,handles)

% --- Executes on button press in reactions.
function reactions_Callback(hObject, eventdata, handles)
% hObject    handle to reactions (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if ~isempty(handles.modelOK)
    OK('Title','Reactions','string','Check the events that are included in cell1 (and need to be replicated into the new cells)');
    data = handles.reactionlist;
    [out,message] = tableGUI('array',data,'ColNames',{'Nr','Reactions'},'ColWidth',[30 600], ...
        'checks','y','FigName','Reaction List','position','center','HorAlin', ...
        'left','reactions',handles.reactionchecks);
    if strcmp(message,'OK')
        handles.reactionchecks = zeros(length(handles.reactionchecks),1);
        for i=1:size(out,1)
            handles.reactionchecks(str2double(out(i,1))) = 1;
        end
    end
else
    OK('Title','Error','string','Model does not conform to requested standards');
end
guidata(hObject,handles);




%--------------------------------------------------------------------------
% EVENTS
%--------------------------------------------------------------------------

% --- Executes during object creation, after setting all properties.
function event_time_CreateFcn(hObject, eventdata, handles)
% hObject    handle to event_time (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function event_time_Callback(hObject, eventdata, handles)
% hObject    handle to event_time (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of event_time as text
%        str2double(get(hObject,'String')) returns contents of event_time as a double
event_time = str2double(get(hObject, 'String'));
if isnan(event_time)
    set(hObject, 'String', 0);
    errordlg('Input must be a number','Error');
end

% Save the new nbCells value
handles.eventdata.event_time = event_time;
guidata(hObject,handles)

% --- Executes during object creation, after setting all properties.
function popupmenu2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes on selection change in popupmenu2.
function popupmenu2_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu2
contents = get(hObject,'String');
handles.eventdata.event_species = contents{get(hObject,'Value')};
guidata(hObject,handles)



% --- Executes during object creation, after setting all properties.
function event_amount_CreateFcn(hObject, eventdata, handles)
% hObject    handle to event_amount (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function event_amount_Callback(hObject, eventdata, handles)
% hObject    handle to event_amount (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of event_amount as text
%        str2double(get(hObject,'String')) returns contents of event_amount as a double
event_amount = str2double(get(hObject, 'String'));
if isnan(event_amount)
    set(hObject, 'String', 0);
    errordlg('Input must be a number','Error');
end

% Save the new nbCells value
handles.eventdata.event_amount = event_amount;
guidata(hObject,handles)


% --- Executes on button press in add_event.
function add_event_Callback(hObject, eventdata, handles)
% hObject    handle to add_event (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if ~isempty(handles.eventdata.event_time) && ~isempty(handles.eventdata.event_species) ...
        && ~isempty(handles.eventdata.event_amount)
    if isempty(handles.events)
        handles.events = {handles.eventdata.event_time ...
            handles.eventdata.event_species handles.eventdata.event_amount 0 };
    else
        handles.events = [handles.events; {handles.eventdata.event_time ...
            handles.eventdata.event_species handles.eventdata.event_amount 0} ];

        %sort events
        [hh,IX] = sort([handles.events{:,1}]);
        g = cell(size(handles.events,1),3);
        for i=1:size(handles.events,1)
            for j=2:4
                g{i,j-1} = handles.events{IX(i),j};
            end
        end
        handles.events = [num2cell(hh') g];
    end

    OK('Title','Event Added','string','Event has been added to the list');
else
    OK('Title','Error','string',strvcat('Event cannot be added to the list','1 or more of the requested fields is empty'));
end

guidata(hObject,handles);

% --- Executes on button press in event_remove.
function event_remove_Callback(hObject, eventdata, handles)
% hObject    handle to event_remove (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if ~isempty(handles.events)
    OK('Title','Remove','string','Uncheck the events you want to remove');
    data = handles.events(:,1:3);
    [out,message] = tableGUI('array',data,'ColNames',{'Time','Species','Amount'},'ColWidth',[50 200 80], ...
        'checks','y','FigName','Event List','position','center');
    if strcmp(message,'OK')
        for i=1:size(out,1)
            out{i,1} = str2double(out{i,1});
            out{i,3} = str2double(out{i,3});
            out{i,4} = handles.events{i,4};
        end
        handles.events = out;
    end
else
    OK('Title','Error','string','No events have been listed yet');
end
guidata(hObject,handles);

% --- Executes on button press in event_list.
function event_list_Callback(hObject, eventdata, handles)
% hObject    handle to event_list (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if ~isempty(handles.events)
    data = handles.events(:,1:3);
    tableGUI('array',data,'ColNames',{'Time','Species','Amount'},'ColWidth',[50 200 80], ...
        'FigName','Event List','position','center');
else
    OK('Title','Error','string','No events have been listed yet');
end



%--------------------------------------------------------------------------
% RUN
%--------------------------------------------------------------------------

% --- Executes on button press in run.
function run_Callback(hObject, eventdata, handles)
% hObject    handle to run (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if ~(handles.modelOK)
    OK('Title','Event Added','string',strvcat('Simulation cannot run when model does not conform to requested standards','Click Help for information'));
else
    OK('Title','Simulation','string',strvcat('Simulation will start after closing this window!','Please watch MATLAB console for more information'));
    
    %load all information again (reset model to start)
    sbioreset
    cd(handles.main.pathname)
    sbioloadproject(handles.main.filename);
    cd(handles.toolboxpath);
    m = sbioselect('Type', 'sbiomodel');
    model = m(1);
    reactions = handles.reactionchecks;
    nbCells = handles.simulationdata.nbCells;
    offset = handles.simulationdata.eq_time;
    rep_time = handles.simulationdata.div_mean;
    spread = handles.simulationdata.div_spread;
    sim_time = handles.simulationdata.sim_time;
    events = handles.events;
    cellDivision_GUI(model,reactions,nbCells,offset,rep_time,spread,sim_time,events)
    
    OK('Title','Simulation','string',strvcat('Simulation has finished!','All variables have been saved in file output.mat'));
end





